#ifndef _metware_util_h
#define _metware_util_h

#include <pharlap.h>
#include "conio.h"

#define SCROLL_UP        0x601
#define SCROLL_DN        0x701

#define CBUF_SIZE        2048
#define loBYTE(w)        (BYTE)(w)
#define hiBYTE(w)        (BYTE)((WORD)(w) >> 8)

#define GetVideoOfs(x,y) (((x) << 1) + _lineOfs[y])

typedef unsigned char   BYTE;
typedef unsigned short  WORD;
typedef unsigned long   DWORD;
typedef int             BOOL;

extern struct text_info conio_scr_info;

extern WORD   screen_seg;
extern WORD   screen_start;
extern WORD   CRT_base;
extern DWORD _linear_scr;
extern BYTE  _far * _scrFp;
extern BYTE  _far * __dosFp;
extern int   _conio_reinit;
extern DWORD _lineOfs [64];

void  conio_init     (void);
void  soundBell      (void);
void  soundBell_BIOS (void);
void  write_ch_BIOS  (int c, int col);
int   _kbhit_intern  (void);

DWORD FastWrite      (int x, int y, int col, char *str);
void  FastWriteCh    (int x, int y, int col, BYTE chr);
WORD  FastFill       (int x, int y, BYTE ch,  int col, int n);
void  ChangeAttr     (int x, int y, int num, int col);
void  ChangeFore     (int x, int y, int num, int col);
void  ChangeBack     (int x, int y, int num, int col);
void  gotoxy_abs     (int x, int y);
WORD  wherexy_abs    (void);

void _ConioWriteFar  (BYTE _far *dest, BYTE *src, int len);
void _ConioReadFar   (BYTE *dest, BYTE _far *src, int len);

 /* implemented in TIMER.ASM */

void  SetHiResTimer  (void);
WORD  GetHiResTimer  (void);
WORD  Get_BIOS_time  (void);
WORD  GetMilliSec    (void);
WORD  StartHiResTimer(void);
WORD  StopHiResTimer (void);

 /* "helpers" for FastWrite()  */

void _setup_fs   (void);
void _restore_fs (void);
void _moveto_fs  (unsigned ofs, WORD value);


 /* screen scroll up/down macros */

#define BIOS_SCROLL(func, x1, y1, x2, y2, col)  { \
        SWI_REGS reg;                             \
        reg.eax = func;                           \
        reg.ebx = col << 8;                       \
        reg.ecx = (x1-1) + ((y1-1) << 8);         \
        reg.edx = (x2-1) + ((y2-1) << 8);         \
        _dx_real_int (0x10,&reg);                 \
      }

#ifdef USE_BIOS_SCROLL
  #define ScrollUp(x1, y1, x2, y2, col)   \
          BIOS_SCROLL (SCROLL_UP,x1,y1,x2,y2,col)

  #define ScrollDown(x1, y1, x2, y2, col) \
          BIOS_SCROLL (SCROLL_DN,x1,y1,x2,y2,col)
#else
  #define ScrollUp(x1, y1, x2, y2, col) {      \
          int width = x2-x1+1;                 \
          movetext (x1,y1+1,x2,y2,x1,y1);      \
          FastFill (x1-1,y2-1,' ',col,width);  \
        }

  #define ScrollDown(x1, y1, x2, y2, col) {    \
          int width = x2-x1+1;                 \
          movetext (x1,y1,x2,y2,x1,y1+1);      \
          FastFill (x1-1,y1,' ',col,width);    \
        }
#endif

#endif  /* _metware_util_h */

