[BITS 16]
[ORG 0x100]

_main:		mov	dx, msg_fail
		call	_A20_DISABLE_
		jz	.exit
		mov	dx, msg_ok

.exit:		mov	ah, 09h
		int	21h
		mov	ax, 4C00h
		int	21h

msg_ok:		db	'A20 DISABLED', 13, 10, '$'
msg_fail:	db	'Could not disable A20', 13, 10, '$'


;
;
;
_A20_DISABLE_:
		call	A20Write
		jz	.exit

		cli				; Only need for reading value from KBC
		mov	al, 0D0h
		out	64h, al
		call	A20Read
		jz	.enable_int

		in	al, 60h
		mov	ah, al
		call	A20Write
.enable_int:	sti
		jz	.exit

		mov	al, 0D1h
		out	64h, al
		call	A20Write
		jz	.exit

		mov	al, ah
		and	al, 0FDh		; Disable line A20
		out	60h, al
		call	A20Write
		jz	.exit

		mov	al, 0FFh
		out	64h, al
		call	A20Write

.exit:		ret

		
; Waits until the Input register is empty or until a short amount
; of time has elapsed. It waits till bit 1 of the KBC Read Status
; Port is clear, Zero.
; Sets the Zero flag if an error occured.
A20Write:	xor	cx, cx			; Reasonable wait
 .get:		in	al, 64h			; Get KBC read status
		test	al, 02			; See if buffer empty, bit 1 clear
		jz	.clear
		dec	cx
		jz	.exit
		jmp	SHORT .get
 .clear:	inc	al			; Clear ZR
 .exit:		ret

; Waits until the Read Status Port, 64h, contains data by checking the state
; of bit 0. It waits till it is set or too much time has gone by.
; Sets the Zero flag if an error occured,
A20Read:	xor	cx, cx
 .get:		in	al, 64h
		test	al, 01			; If the 'output buffer' is full, has
		jnz	.exit			; something for me
		dec	cx
		jnz	.get
 .exit:		ret