/* This REXX script alters the source code of Patrick McPhee's REXX
 * regular expression add-on DLL. Specifically, it modifies the
 * C source files name rexxre.c, rxsupport.c, rxproto.h, and
 * rexxre.def in order to not use REXXTRANS, but still support
 * several REXX interpreters with one DLL. It also adds support for
 * Reginald's auto-loading.
 *
 * Copy this script to the same directory as rexxre.c before running
 * it.
 *
 * Along with this script, you'll find a Microsoft Visual C++ project
 * file (REXXRE.MDP, along with REXXRE.MAK, REXXRE.NCB, and REXXRE.APS)
 * to allow recompiling the DLL with Microsoft Visual C++ 4.0 or later.
 */

Prepend.1 = '#ifdef WIN32'
Prepend.2 = '#undef REXXFREEMEMORY'
Prepend.3 = '#undef REXXALLOCATEMEMORY'
Prepend.4 = 'typedef void * APIENTRY RxAllocateMemoryPtr(unsigned long);'
Prepend.5 = 'typedef long APIENTRY RxFreeMemoryPtr(void *);'
Prepend.6 = 'typedef long APIENTRY RxDeregisterFunctionPtr(const char *);'
Prepend.7 = 'typedef long APIENTRY RxRegisterFunctionDllPtr(const char *, const char *, const char *);'
Prepend.8 = 'typedef long APIENTRY RxVariablePoolPtr(PSHVBLOCK);'
Prepend.9 = 'extern RxFreeMemoryPtr *REXXFREEMEMORY;'
Prepend.10 = 'extern RxAllocateMemoryPtr *REXXALLOCATEMEMORY;'
Prepend.11 = 'extern RxVariablePoolPtr *RexxVariablePoolA;'
Prepend.12 = 'extern RxRegisterFunctionDllPtr *RexxRegisterFunctionDllA;'
Prepend.13 = 'extern RxDeregisterFunctionPtr *RexxDeregisterFunctionA;'
Prepend.14 = '#else'
Prepend.15 = '#define REXXALLOCATEMEMORY malloc;'
Prepend.16 = '#define REXXFREEMEMORY free;'
Prepend.17 = '#define RexxVariablePoolA RexxVariablePool'
Prepend.18 = '#define RexxRegisterFunctionDllA RexxRegisterFunctionDll'
Prepend.19 = '#define RexxDeregisterFunctionA RexxDeregisterFunction'
Prepend.20 = '#endif'
Prepend.21 = ''

/* Load RXPROTO.H */
err = LOADTEXT('Lines.', 'rxproto.h')
IF err = 0 THEN DO
	SAY "Can't open rxproto.h:" STREAM('rxproto.h', 'D')
	EXIT
END

/* Find the place where we want to insert some new #define's */
insertPoint = 0
DO i = 1 TO Lines.0

	IF Lines.i == '#ifndef REXXALLOCATEMEMORY' THEN Lines.i = '#ifndef _REXXALLOCATEMEMORY'

	/* Modify the REXXALLOCATEMEMORY section. We want to use the special
	 * REXX interpreter friendly version for memory allocation/deallocation.
	 */
	IF Lines.i == '#  define REXXALLOCATEMEMORY malloc' THEN DO

		Lines.i = ''
		i = i + 1
		Lines.i = ''

		/* Save the point where we insert extra stuff */
		insertPoint = i
		LEAVE i

	END /* REXXALLOCATEMEMORY */
END

IF insertPoint == 0 THEN DO
	SAY "Can't find the lines to modify in rxproto.h!"
	EXIT
END

/* Create a new RXPROTO.H */
IF STREAM('rxproto.h', 'C', 'OPEN WRITE REPLACE') \== 'READY:' THEN DO
	SAY "Can't rewrite rxproto.h:" STREAM('rxproto.h', 'D')
	EXIT
END

/* Write out the new RXPROTO.H */
DO i = 1 to Lines.0

	/* Need to insert new lines? */
	IF i = insertPoint THEN DO
		p = 1
		DO UNTIL Prepend.p = ''
			CALL LINEOUT 'rxproto.h', Prepend.p
			p = p + 1
		END
	END

	/* Write the next line */
	CALL LINEOUT 'rxproto.h', Lines.i

END

/* Close the file */
CALL STREAM 'rxproto.h', 'C', 'CLOSE'







/* Load rexxre.c */
err = LOADTEXT('Lines.', 'rexxre.c')
IF err = 0 THEN DO
	SAY "Can't open rexxre.c:" STREAM('rexxre.c', 'D')
	EXIT
END

/* Change references */
DO i = 1 TO Lines.0

	/* Change any references to RexxDeregisterFunction to RexxDeregisterFunctionA */
	IF POS('RexxDeregisterFunction', Lines.i) \== 0 THEN DO
		Lines.i = CHANGESTR('RexxDeregisterFunction', Lines.i, 'RexxDeregisterFunctionA')
	END

	/* Change any references to RexxRegisterFunctionExe to RexxRegisterFunctionDllA */
	ELSE IF POS('RexxRegisterFunctionExe', Lines.i) \== 0 THEN DO
		Lines.i = '#ifdef WIN32' || '0D0A09'X || 'RexxRegisterFunctionDllA(funclist[i].name, "rexxre.dll", funclist[i].funcptr);' || '0D0A'X || "#else" || '0D0A'X || Lines.i || '0D0A'X || "#endif" || '0D0A'X
	END

	/* We need to modify the function name list */
	ELSE IF Lines.i = "APIRET (APIENTRY*funcptr)(PUCHAR fname, ULONG argc, PRXSTRING argv, PSZ pSomething, PRXSTRING result);" THEN DO
	
		Lines.i = '#ifndef WIN32' || '0D0A'X || Lines.i || '0D0A'X || '#else' || '0D0A09'X || 'char *funcptr;' || '0D0A'X || "#endif" || '0D0A'X || "} funclist[] = {"
		i = i + 1
		Lines.i = '#ifndef WIN32'
		i = i + 1
		Prepend = ""
	
		DO UNTIL Lines.i = '};'
			err = CHANGESTR(', ', Lines.i, ', "')
			err = CHANGESTR('}', err, '"}')
			Prepend = Prepend || '0D0A'X || err
			i = i + 1
		END
		Lines.i = '#else' || Prepend || '0D0A'X || '#endif' || '0D0A'X || '};'
	END

END

/* Create a new rexxre.c */
IF STREAM('rexxre.c', 'C', 'OPEN WRITE REPLACE') \== 'READY:' THEN DO
	SAY "Can't rewrite rexxre.c:" STREAM('rexxre.c', 'D')
	EXIT
END

/* Save the above lines */
CALL LOADTEXT 'Lines.', 'rexxre.c', 'S'

/* Append support for Reginald's auto-load */
Autoload.1 = '0D0A'X || 'APIRET APIENTRY RexxRegisterFuncs(void)'
Autoload.2 = '{'
Autoload.3 = '09'X || 'RXSTRING rx;'
Autoload.4 = '09'X || 'char buffer[4];' || '0D0A'X
Autoload.5 = '09'X || 'rx.strptr = &buffer[0];'
Autoload.6 = '09'X || 'reloadfuncs(0, 0, 0, 0, &rx);'
Autoload.7 = '09'X || 'return(0);'
Autoload.8 = '}'
Autoload.9 = ''
p = 1
DO UNTIL Autoload.p = ''
	CALL LINEOUT 'rexxre.c', Autoload.p
	p = p + 1
END

/* Close the file */
CALL STREAM 'rexxre.c', 'C', 'CLOSE'






/* Open rexxre.def and move to the end */
IF STREAM('rexxre.def', 'C', 'OPEN WRITE APPEND') \== 'READY:' THEN DO
	SAY "Can't rewrite rexxre.def:" STREAM('rexxre.def', 'D')
	EXIT
END

/* Write out the RexxRegisterFuncs */
CALL LINEOUT 'rexxre.def', 'EXPORTS RexxRegisterFuncs'

/* Close the file */
CALL STREAM 'rexxre.def', 'C', 'CLOSE'








/* Determine how many characters in 'rxsupport.c' */
total = CHARS('rxsupport.c')

/* Anything to read? */
IF total > 0 THEN DO

	/* Read those chars */
	data = CHARIN('rxsupport.c', , total)

	/* Check for an error */
	IF STREAM('rxsupport.c', "D") \== "" THEN DO
		SAY "Can't read rxsupport.c:" STREAM('rxsupport.c', "D")
		EXIT
	END

	CALL STREAM 'rxsupport.c', 'C', 'CLOSE'

	/* Go through it and change any references to RexxVariablePool to RexxVariablePoolA */
	data = CHANGESTR('RexxVariablePool', data, 'RexxVariablePoolA')

	/* Write out the new file */
	err = CHAROUT('rxsupport.c', data, 1)
	IF err \== 0 THEN DO
		SAY "Can't rewrite rxsupport.c:" STREAM('rxsupport.c', 'D')
		EXIT
	END
END



SAY "Done!"