/* ************************ CgiCleanQuery() *************************
 * Removes all occurences of unassigned variables from a CGI query
 * string. CGI query strings are of the form VAR1=value1&VAR2=value2&...
 * It is possible for a Web form to generate "VAR=" elements, with no
 * assignment, which in many cases are removable from the query without
 * effect. The remaining elements are preserved in order and in case.
 *
 * new_cgi_string = CgiCleanQuery(cgi_string)
 *
 * Example: CgiCleanQuery("A=5&B=&C=&B=abc") returns "A=5&B=abc".
 *
 * 970221  Michael Kelsey
 */
CgiCleanQuery:	PROCEDURE
	qstring = ARG(1)
	qnew = ''
	DO WHILE qstring \= ''
		PARSE VAR qstring piece'='val'&' qstring
		IF val \= '' THEN qnew = qnew'&'piece'='val
	END
	qnew = STRIP(qnew, 'B', '&')
	RETURN qnew