/* ************************** CgiDelQuery() ***************************
 * Removes all occurences of a given CGI query variable from the input
 * string. CGI query strings are of the form VAR1=value1&VAR2=value2&...
 * The matching is not case sensitive, and the result is returned with
 * the same case as the input string.
 *
 * new_cgi_string = CgiDelQuery(cgi_string, varname)
 *
 * cgi_string =	The CGI string from which to strip a variable.
 * varname = The name of the variable to strip out.
 *
 * EXAMPLE: CgiDelQuery("A=5&B=2&C=3&B=ABC","B") returns "A=5&C=3".
 *
 * 970221  Michael Kelsey
 * 970303  Steve Meyer, replace UPPER with TRANSLATE, add Qstring to all RETURNs
 */

CgiDelQuery: PROCEDURE
	PARSE ARG qstring, varname
	IF varname = '' THEN RETURN qstring
	PARSE UPPER ARG qup, vup			/* Case-insensitive version for matching */
	DO WHILE POS(vup || '=', qup) > 0	/* Case-insensitive matching */
		a = POS(vup || '=', qup)
		b = POS('&', qup, a)
		IF b = 0 THEN b = LENGTH(qup)
		qstring = STRIP(SUBSTR(qstring, 1, a-1) || SUBSTR(qstring, b+1), 'T', '&')
		qup = TRANSLATE(qstring)
	END
	RETURN qstring