/************** CgiError() ********************
 * Outputs to STDOUT (ie, the GCI gateway) a
 * complete HTML page that contains some sort
 * of error message.
 *
 * CALL CgiError Title, Message
 * 
 * Title = The title of the page. (ie, Appears in
 *			the client's web browser title bar).
 * Message = The error message.
 *
 * If Title is omitted, then a generic title is
 * created.
 *
 * EXAMPLE: CALL CgiError "My Title", "Wrong string detected."
 */
CgiError:
	USE ARG Title, Message
	IF Title = '' THEN Title = 'Error: script' MyURL() 'encountered fatal error.'
	SAY '<html><head><title>'Title'</title></head>'
	SAY '<body><h1>'Title'</h1>'
	IF Message \= '' THEN SAY Message
	SAY '</body></html>'
	RETURN