/* ************************ CgiFullURL() *************************
 * Rebuilds complete CGI query URL from CGI environment variables.
 * The "REFERER_URL" string stops at the name of the CGI script,
 * eliminating any path or query information. This makes it
 * difficult to embed the original query for reference in script
 * output.
 *
 * fullUrl = CgiFullURL()
 *
 * 970221  Michael Kelsey
 */

CgiFullURL: PROCEDURE
	pathname = GETENV('PATH_INFO')
	query = GETENV('QUERY_STRING')
	fullURL = 'http://' || GETENV('HTTP_HOST') || GETENV('SCRIPT_NAME')
	IF pathname \= '' THEN fullURL = fullURL || pathname
	IF query \= '' THEN fullURL = fullURL'?'query
	RETURN fullURL