/* ******************** CgiGetVariables() ************************
 * Decodes the Form data block variables (which are in the
 * format key1=value1&key2=value2&...) and returns them in the
 * specified stem variable.
 *
 * CALL CgiGetVariables(KeyStemName., ValueStemName., FormData)
 *
 * KeyStemName. = The desired stem variable name for the keys. Do
 *				 not quote it.
 * ValueStemName. = The desired stem variable name for the values.
 *				 Do not quote it.
 * FormData = The form data as returned by GciReadPost() or GciReadForm().
 *
 * RETURNS: Sets the KeyStemName. and ValueStemName. to the
 * form data as described below.
 *
 * EXAMPLE:
 * Assume that the form data from the GCI gateway is as so:
 *
 * NAME=John Doe&ADDRESS=100 Maple Ave&Phone=555-3107&
 *
 * There are three items in the above string. If you call as so:
 *
 * CALL CgiGetVariables(KeyStem., ValueStem., "NAME=John Doe&ADDRESS=100 Maple Ave&Phone=555-3107&")
 *
 * Then ValueStem.0 is set to a count of how many values there are.
 * In this case, that would be three. ValueStem.1 is set to the first
 * value (ie, "John Doe") and KeyStem.1 is set to its key
 * (ie, "NAME"). ValueStem.2 is set to the second value (ie, "100
 * Maple Ave") and KeyStem.2 is set to its key ("ADDRESS").
 * ValueStem.3 is set to the third value (ie, "555-3107") and
 * KeyStem.3 is set to its key ("PHONE").
 *
 * NOTE: All keys are uppercased.
 */

CgiGetVariables: PROCEDURE
	USE ARG keystem. valstem.
	in = ARG(2)

	/* Parse all the keys/values */
	DO i = 1 BY 1 UNTIL in = ''
	
		/* Split off the next key and its value */
		PARSE VAR in key'='val'&' in
		
		/* Convert %XX from hex to alphanumeric and stuff into
		 * the next set of compounds
		 */
		keystem.i = GciDeWeb(key, '+')
		valstem.i = GciDeWeb(val, '+')

	END
	RETURN