/* ******************** CgiPrintHeader() *********************
 * Returns the magic line which tells the GCI gateway what
 * kind of document is to follow.
 *
 * line = CgiPrintHeader(Content, UrlFlag)
 *
 * If "Content" is omitted, then this simply returns a
 * document type of HTML (along with the trailing newline
 * so that you can then immediately follow up by SAY'ing
 * the actual web page -- ie, no need for a second, lone
 * SAY).
 *
 * Otherwise, Content is either a type/subtype, or a
 * URL. UrlFlag should be 1 if a URL, or omitted if a
 * type/subtype.
 *
 * EXAMPLES:
 *   SAY CgiPrintHeader() /* Creates an HTML type */
 *   SAY CgiPrintHeader('http://www.halcyon.com/hedlund/cgi-faq/',1) /* Creates a URL type */
 *   SAY CgiPrintHeader('Status: 305 Document moved',0) /* Creates a 'Status:' report */
     SAY CgiPrintHeader('application/postscript') /* Creates an 'application/postscript' type */
*/
CgiPrintHeader:
	IF ARG(1, 'E') == 0 THEN RETURN 'Content-type: text/html' || '0A'X
	IF ARG(2, 'E') == 0 THEN RETURN ARG(1)
	IF ARG(2) == '1' THEN RETURN 'Location:' ARG(1)
	RETURN 'Content-type:' ARG(1) || '0A'X
