/* ***************** CgiPrintVariables() **********************
 * Decodes the Form data block variables (which are in the
 * format key1=value1&key2=value2&...) and returns them in a
 * nicely formatted HTML string.
 *
 * HTMLstring = CgiPrintVariables(formDataBlock)
 *
 * EXAMPLE:
 *  SAY CgiPrintVariables(GETENV('QUERY_STRING'))
 */

CgiPrintVariables: PROCEDURE
	PARSE ARG in
	out = '0A'X || '<dl compact>' || '0A'X
	DO i = 1 BY 1 UNTIL in = ''
		/* Split into key and value */
		PARSE VAR in key.i'='val.i'&' in
		/* Convert %XX from hex to alphanumeric*/
		key.i = GciDeWeb(key.i, '+')
		val.i = GciDeWeb(val.i, '+')
		out = out || '<dt><b>' || key.i || '</b>' || '0A'X || '<dd><i>' || val.i || '</i><br>' || '0A'X
	END
	RETURN out || '</dl>' || '0A'X