/* ******************* CgiReadForm *********************
 * Reads in GET or POST data, converting plus signs (+) 
 * to spaces. Does not convert %XX encoded characters 
 * to unescaped text since this would confuse encoded
 * ampersands and equal signs with those used to
 * separate the fields in the name=value& pairs.
 * Returns the converted input if there is any, else
 * returns an empty string.
 *
 * data = CgiReadForm()
 */
CgiReadForm: PROCEDURE
	/* Note: Reginald triggers NOVALUE if we use GETENV() to read
	 * an environment variable, and no such variable has been set.
	 * So let's do this to catch errors.
	 */
	SIGNAL ON NOVALUE NAME CgiReadFormError

	/* See which method the CGI interface used to pass us data from
	 * some form on the web page.
	 */
	method = GETENV('REQUEST_METHOD')

	/* If a 'GET' method, then the CGI interface has set the
	 * environment variable named 'QUERY_STRING' to the data. We can
	 * grab it with GETENV().
	 */
	IF method == 'GET' THEN RETURN TRANSLATE(GETENV('QUERY_STRING'), ' ', '+')

	/* If a 'POST' method, then the CGI interface has written the data to
	 * standard input. We can grab it with CHARIN() by omitting the filename
	 * (ie, first) arg. Note that we use GETENV() to query the environment
	 * variable named 'CONTENT_LENGTH'. The CGI interface set this to the
	 * number of characters that it queued for us. Also, let's trap
	 * NOTREADY in case of an error.
	 */
	SIGNAL ON NOTREADY NAME CgiReadFormError2
	IF method == 'POST' THEN RETURN TRANSLATE(CHARIN(, 1, GETENV('CONTENT_LENGTH')), ' ', '+')

	/* No data */
	RETURN ""

CgiReadFormError:
	/* Raise an ERROR condition in the caller */
	RAISE ERROR 1 DESCRIPTION (CONDITION('D') "environment variable was not set!") RETURN ""

CgiReadFormError2:
	/* Raise an ERROR condition in the caller */
	RAISE ERROR 2 DESCRIPTION ("Form data could not be read!") RETURN ""