/* *********************** CgiStripHTML() ************************
 * Simplistically removes HTML tags from an input string.  No use of
 * context or semantic information is done -- every <.....> tag is just
 * removed.
 *
 * new_String = CgiStripHTML(string)
 *
 * Example: CgiStripHTML("<H1><IMG SRC="babar.gif"> BaBar Experiment</H1>")
 *          returns " BaBar Experiment"
 *
 * 970221  Michael Kelsey
 */
CgiStripHTML: PROCEDURE
	PARSE ARG in
	out = ''
	tag = 0
	i = 1
	DO UNTIL i > LENGTH(in)
		ch = SUBSTR(in,i,1)
		tag = tag | (ch = '<')		/* Beginning of HTML tag */
		IF tag=0 THEN out = out||ch
		tag = tag & (ch \= '>')		/* End of HTML tag */
		i = i + 1
	END
	RETURN out