/* This example determines whether we have some input from
 * the CGI interface. If so, we simply spit out a web page
 * containing a <TABLE> that shows the data we got.
 *
 * If no data, we instead spit out a web page containing a
 * form to get some data, and hope the CGI interface calls
 * us again with some actual data.
 */

/* Tell the CGI gateway that we're writing out an HTML document */
SAY CgiPrintHeader()

SAY '<body bgcolor="FFFFFF">'

/* Get the form data from either a POST or GET from the CGI interface.
 * If there is a problem, then ERROR condition is raised.
 */
SIGNAL ON ERROR NAME ReadProblem
CALL CgiReadPost input

/* Did we have any data? */
IF SYMBOL(input) \== 'VAR' THEN DO

	/* No, we did't. Let's get some by sending the CGI interface a
	 * web page with a form on it to let the user enter some
	 * data. Then when he submits the form, the CGI interface will
	 * call our script again, and this time, ReadForm() will have
	 * some data for us.
	 */

	/* Set the HTML document's title to "Minimal Form" */
	SAY, CgiHtmlTop('Minimal Form')

	/* Write out a <FORM> tag to get some user data */
	SAY '<form><input type="submit"><br>Data: <input name="myfield">'
END

ELSE DO

	/* Set the HTML document's title to "Output from Minimal Form" */
	SAY CgiHtmlTop('Output from Minimal Form') 

	/* Display the CGI variables and their values that were returned
	 * in the form data. Normally, we'd do something useful with the
         * data (such as call CgiGetVariables() to break it up into stem
         * variables) rather than just spit out a web page showing what
         * we received.
	 */
	SAY CgiPrintVariables(input)
END

/* Write out the end of the HTML document */
CALL LINEOUT , CgiHtmlBot()
RETURN

ReadProblem:
    /* CONDITION('D') contains the error string. We'd have to display
     * this in a message box if there is a human observing this
     * script. We don't want to SAY it since that would go back to
     * the CGI interface. Alternately, if no human is monitoring this
     * script, we could use LINEOUT to write it to some log file.
     */

     /* Reginald's CONDITION('M') will display the error message in a message box */
/*     CALL CONDITION('M') */