/* This example simply spits out a web page containing
 * whatever data was sent by the GCI interface. The
 * GCI interface can send data several ways, by passing
 * it to our script, storing it in the QUERY_STRING or
 * PATH_INFO environment variables, or queueing that
 * data at standard input. This script tries to read
 * data from all of those sources. Normally, you'd know
 * what the FORM tag on your web page is doing, so you'd
 * know how to expect the data to be sent to you.
 */

/* Tell the GCI gateway we are writing out an HTML document. */
SAY CgiPrintHeader()

/* Format the <HEAD><BODY> tag of the HTML document. */
SAY CgiHtmlTop('testinput')

/* Read input from the various sources, and just spit out
 * a web page with the data. Normally, you'd do something
 * useful with the data rather than just spit it back out
 * in a web page.
 */

/* Get the QUERY_STRING that has been passed us for a non-FORM */
PARSE ARG Parms
SAY '<PRE>Data passed to the REXX script = "'Parms'"</PRE>'

/* Get the same data, but encoded to replace spaces with plus signs
 * and %XX with special characters.
 */
SAY '<P><PRE>QUERY_INPUT environment variable = "'GETENV('QUERY_STRING')'"</PRE>'

/* Get data sent via the POST method of a FORM */
SAY '<P><PRE>Standard input = "'CgiReadPost()'"</PRE>'

/* Get data sent via the PATH_INFO environment variable */
SAY '<P><PRE>PATH_INFO environment variable = "'GETENV('PATH_INFO')'"</PRE>'

/* Format the end of the HTML document */
SAY CgiHtmlBot()

RETURN