// TestRoo.java

// the TestRoo program uses the Java Native Interface (JNI)
// to communicate with the roo.dll. The corresponding
// roo.java program provides the native wrappers for the
// roo.dll's Java entry points.

import java.io.*;

import java.util.*;

import roo; // bring in the native code wrapper -- roo.class

public class TestRoo 
{
	static
	{
		// you can uncomment the following and use an absolute path if necessary

		// String sRooDllFileName = "g:\\r4\\roo.dll";

		// normally, the roo.dll is placed in the Java startup directory

		String sRooDllFileName = System.getProperty( "user.dir" ) + "\\roo.dll";

		System.load( sRooDllFileName );
	}

    public static void main( String[] args )
    {
		roo r = new roo();

		if( args.length > 0 )
			System.out.println( r.PerformRooProgram( "extroo.rooProgram", args ) );

		else if( true )
		{
			int nArguments = 3;

			String[] aArguments = new String[ nArguments ];

			aArguments[ 0 ] = "abracadabra";
			aArguments[ 1 ] = "open sesame";
			aArguments[ 2 ] = "shazam";

			String sInstanceLocator = r.CreateRooClass( "vector", aArguments );

			System.out.println( "CreateRooClass, sInstanceLocator: " + sInstanceLocator );

			int nDelimiterArguments = 1;

			String[] aDelimiterArguments = new String[ nDelimiterArguments ];

			aDelimiterArguments[ 0 ] = "^";

			System.out.println( "toDelimitedString: " + r.InvokeRooClassMethod( sInstanceLocator, "toDelimitedString", aDelimiterArguments ) );

			System.out.println( "RemoveRooClassInstance: " + r.RemoveRooClassInstance( sInstanceLocator ) );
		}

		else if( true )
		{
			Vector vArguments = new Vector();

			vArguments.addElement( "abracadabra" );

			System.out.println( r.ExecuteRooFunctionUsingVector( "translate", vArguments ) );
		}

		else
		{
			int nArguments = 3;

			String[] aArguments = new String[ nArguments ];

			aArguments[ 0 ] = "abracadabra";
			aArguments[ 1 ] = "open sesame";
			aArguments[ 2 ] = "shazam";

			System.out.println( r.PerformRooProgram( "SayArgs", aArguments ) );
		}
    }
}
