// roo.java

// roo.java is the native Java wrapper for the roo.dll.

import java.util.Vector;

public class roo
{
	// the following are the native 'roo' interfaces:
	//
	//  Initialize -- establish caption for error messages
	//
	//  Terminate -- conclude roo.dll usage
	//
	//  Perform -- perform a roo external program, returns result
	//
	//  ExecuteFunction -- execute a roo built-in function, returns result
	//
	//  CreateClass -- create an instance of a roo class, returns a class instance locator
	//
	//  InvokeMethod -- invoke a method of a roo class instance, returns result
	//
	//  RemoveInstance -- remove a roo class instance, returns empty string usually

    public native String Initialize(
		String sMessageBoxCaption );

    public native String Terminate();

    public native String Perform(			// perform a roo external program
    	String optionalCallbackMethodName,
		String sProcedure,
		String[] aArgument );

    public native String ExecuteFunction(	// execute a roo built-in function
    	String optionalCallbackMethodName,
		String sFunction,
		String[] aArgument );

    public native String CreateClass(		// create an instance of a roo class
    	String optionalCallbackMethodName,
		String sClassName,
		String[] aArgument );

    public native String InvokeMethod(		// invoke a method of a roo class instance
    	String optionalCallbackMethodName,
		String sInstanceLocator, // returned by 'CreateClass'
		String sMethodName,
		String[] aArgument );

    public native String RemoveInstance(	// remove a roo class instance
		String sInstanceLocator ); // returned by 'CreateClass'

//--------------------------------------------------------------------------------------------------------------

	// the following are the Java invocations, of the native interfaces, with String[ ] arguments

	public String InitializeRoo( String sMessageBoxCaption )
	{
		return Initialize( sMessageBoxCaption );
	}

	public void TerminateRoo()
	{
		Terminate();
	}

	public String PerformRooProgram( String sProcedure, String[] aArgument )
	{
		return Perform(
			"performCallback",
			sProcedure,
			aArgument  );
	}

	public String ExecuteRooFunction( String sFunction, String[] aArgument )
	{
		return ExecuteFunction(
			"performCallback",
			sFunction,
			aArgument  );
	}

	public String CreateRooClass( String sClassName, String[] aArgument )
	{
		return CreateClass(
			"createClassCallback",
			sClassName,
			aArgument  );
	}

	public String InvokeRooClassMethod( String sInstanceLocator, String sMethodName, String[] aArgument )
	{
		return InvokeMethod(
			"invokeMethodCallback",
			sInstanceLocator,
			sMethodName,
			aArgument  );
	}

	public String RemoveRooClassInstance( String sInstanceLocator )
	{
		return RemoveInstance( sInstanceLocator );
	}

//--------------------------------------------------------------------------------------------------------------

	// the following are the Java invocations, of the native interfaces, with Vector of String arguments

	public String PerformRooProgramUsingVector( String sProcedure, Vector vArgument )
	{
		return Perform(	"performCallback", sProcedure, ConvertStringVectorToArray( vArgument ) );
	}

	public String ExecuteRooFunctionUsingVector( String sFunction, Vector vArgument )
	{
		return ExecuteFunction(	"performCallback", sFunction, ConvertStringVectorToArray( vArgument ) );
	}

	public String CreateRooClassUsingVector( String sClassName, Vector vArgument )
	{
		return CreateClass(
			"createClassCallback",
			sClassName,
			ConvertStringVectorToArray( vArgument )  );
	}

	public String InvokeRooClassMethodUsingVector( String sInstanceLocator, String sMethodName, Vector vArgument )
	{
		return InvokeMethod(
			"invokeMethodCallback",
			sInstanceLocator,
			sMethodName,
			ConvertStringVectorToArray( vArgument )  );
	}

//--------------------------------------------------------------------------------------------------------------

	// the following is a worker function that converts a Vector of String's to a String[ ] equivalent

	private String[] ConvertStringVectorToArray( Vector vArgument )
	{
		if( vArgument == null )
			return null;

		int nArguments = vArgument.size();

		String[] aArgument = new String[ nArguments ];

		for( int i=0; i < nArguments; i++ )
			aArgument[ i ] = (String) vArgument.elementAt( i );

		return aArgument;
	}

//--------------------------------------------------------------------------------------------------------------

	// the following are example call back methods

	public String performCallback( String[] aArgument )
	{
		System.out.println( "performCallback" );

		for( int i=0; i < aArgument.length; i++ )
		{
			System.out.println( "Argument " + Integer.toString( i + 1 ) + ". " + aArgument[ i ] );
		}

		return "Proceed";
	}

	public String executeCallback( String[] aArgument )
	{
		System.out.println( "executeCallback" );

		for( int i=0; i < aArgument.length; i++ )
		{
			System.out.println( "Argument " + Integer.toString( i + 1 ) + ". " + aArgument[ i ] );
		}

		return "Proceed";
	}

	public String createClassCallback( String[] aArgument )
	{
		System.out.println( "createClassCallback" );

		for( int i=0; i < aArgument.length; i++ )
		{
			System.out.println( "Argument " + Integer.toString( i + 1 ) + ". " + aArgument[ i ] );
		}

		return "Proceed";
	}

	public String invokeMethodCallback( String[] aArgument )
	{
		System.out.println( "invokeMethodCallback" );

		for( int i=0; i < aArgument.length; i++ )
		{
			System.out.println( "Argument " + Integer.toString( i + 1 ) + ". " + aArgument[ i ] );
		}

		return "Proceed";
	}
}
