// rooDll.h
// header file with definitions of exported entry points of roo.dll

# ifndef ROO_DLL_H_
# define ROO_DLL_H_

# pragma once

# define WIN32_LEAN_AND_MEAN
# include <windows.h>

# define REV_20021223 1

# ifdef REV_20021223
#include "G:\jdk1.1.8\include\jni.h" // modify this to locate your jni.h file in the Java SDK
# endif

// The following ifdef block is the standard way of creating macros which make exporting 
// from a DLL simpler. All files within this DLL are compiled with the ROODLL_EXPORTS
// symbol defined on the command line. this symbol should not be defined on any project
// that uses this DLL. This way any other project whose source files include this file see 
// ROODLL_API functions as being imported from a DLL, wheras this DLL sees symbols
// defined with this macro as being exported.
#ifdef ROODLL_EXPORTS
#define ROODLL_API __declspec(dllexport)
#else
#define ROODLL_API __declspec(dllimport)
#endif

extern "C"
{
# ifdef ANNOTATION

	// Java interfaces

	ROODLL_API jstring JNICALL Java_roo_Initialize(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject,
		jstring sMessageBoxCaption );

	ROODLL_API void JNICALL Java_roo_Terminate(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject );

	ROODLL_API jstring JNICALL Java_roo_Perform(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject,
    	jstring optionalCallbackMethodName,
		jstring sProcedureName,
    	jobjectArray aArgument ); // an array of strings -- java: String[ ], can be null

	ROODLL_API jstring JNICALL Java_roo_ExecuteFunction(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject,
    	jstring optionalCallbackMethodName,
		jstring sFunctionName,
    	jobjectArray aArgument ); // an array of strings -- java: String[ ], can be null

	ROODLL_API jstring JNICALL Java_roo_CreateClass(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject,
    	jstring optionalCallbackMethodName,
		jstring sClassName,
    	jobjectArray aArgument ); // an array of strings -- java: String[ ], can be null

	ROODLL_API jstring JNICALL Java_roo_InvokeMethod(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject,
    	jstring optionalCallbackMethodName,
		jstring sInstanceLocator,
		jstring sMethodName,
    	jobjectArray aArgument ); // an array of strings -- java: String[ ], can be null

	ROODLL_API jstring JNICALL Java_roo_RemoveInstance(
		JNIEnv* pJavaEnvironment,
		jobject rJavaObject,
		jstring sInstanceLocator );
# endif

	// in the following, invocationContext is a unique calling context identifier

	// note: the triple dots at the end of these prototypes circumvents C++ decorated name challenges !

	// multiple additional parameters are potentially passed for the Initialize function,
	// and functions that are invoked by a roo ExternalClass 'perform' method request

	typedef GLOBALHANDLE (CALLBACK* callback_method_t ) ( LPCTSTR invocationContext, LPCTSTR pCallbackOption, ... );

	ROODLL_API void WINAPI SetCallback( LPCTSTR invocationContext, callback_method_t Callback, ... );

# ifdef REV_20021223

	// initialize roo.dll environment

	ROODLL_API void WINAPI Initialize(
		LPCTSTR pMessageBoxCaption );

	// conclude roo.dll usage

	ROODLL_API void WINAPI Terminate();
# endif

	// the following functions begin a roo DLL 'perform' method request
	// invocationContext is a calling context identifier
	// pCallbackOption is a value to pass back during a callback operation
	// pInitialProcedure is the name of a rooProgram to execute

	ROODLL_API GLOBALHANDLE WINAPI Perform(
		LPCTSTR pInitialProcedure,
		... );

	ROODLL_API GLOBALHANDLE WINAPI PerformWithCallback(
		LPCTSTR invocationContext,
		LPCTSTR pCallbackOption,
		LPCTSTR pInitialProcedure,
		... );

	// the following function begins a roo DLL built-in function request
	// pBuiltinFunctionName is the name of the built-in function to execute

	ROODLL_API GLOBALHANDLE WINAPI ExecuteFunction(
		LPCTSTR pBuiltinFunctionName,
		... );

	// the following functions begin a roo DLL 'create class' request
	// invocationContext is a calling context identifier
	// pCallbackOption is a value to pass back during a callback operation
	// pClassName is the name of a class instance to construct
	// additional arguments that follow the pClassName will be passed to the initialization method
	// if construction is successful, an instanceLocator is returned in string form -- it begins with: a } and ends with a {
	// if construction is not successful, the initialization method error message text is returned

	ROODLL_API GLOBALHANDLE WINAPI CreateClass(
		LPCTSTR pClassName,
		... );

	ROODLL_API GLOBALHANDLE WINAPI CreateClassWithCallback(
		LPCTSTR invocationContext,
		LPCTSTR pCallbackOption,
		LPCTSTR pClassName,
		... );

	// the following functions begin a roo DLL 'invoke method' request
	// invocationContext is a calling context identifier
	// pCallbackOption is a value to pass back during a callback operation
	// pInstanceLocator is a value returned from a 'create' method request, or a prior method invocation
	// pMethodName is the name of the method to invoke
	// additional arguments that follow the pMethodName will be passed to the method
	// the method result is returned -- it may be another instanceLocator in string form

	ROODLL_API GLOBALHANDLE WINAPI InvokeMethod(
		LPCTSTR pInstanceLocator,
		LPCTSTR pMethodName,
		... );

	ROODLL_API GLOBALHANDLE WINAPI InvokeMethodWithCallback(
		LPCTSTR invocationContext,
		LPCTSTR pCallbackOption,
		LPCTSTR pInstanceLocator,
		LPCTSTR pMethodName,
		... );

	// the following function begins a roo DLL 'remove instance' request
	// invocationContext is a calling context identifier -- unused by RemoveInstance
	// pCallbackOption is a value to pass back during a callback operation -- unused by RemoveInstance
	// pInstanceLocator is a value returned from a 'create' method request, or a prior method invocation, that will be removed
	// no arguments are expected after the instance locator -- additional arguments are ignored
	// the global handle that is returned is always an empty string

	ROODLL_API GLOBALHANDLE WINAPI RemoveInstance(
		LPCTSTR pInstanceLocator,
		... );

};

# endif // ROO_DLL_H_
